<?php

class Tbp_Dynamic_Query_Wishlisted {

    static function get_id():string {
        return 'wishlisted';
    }

    static function get_label():string {
        return __( 'Wishlisted Products', 'tbp' );
    }

    static function get_options():array {
        return [];
    }

    private static function is_active() : bool {
        return isset( $_POST['action'] ) && $_POST['action'] === 'tb_render_element';
    }

    static function pre_get_posts( &$query, ?array $settings=array() ):bool {
        if ( themify_is_ajax() && ! self::is_active() ) {
            $wishlist = Tbp_Wishlist::get();
            $query->set( 'post__in', $wishlist + [ 0 ] );
            $query->set( 'posts_per_page', 0 ); // ignore pagination settings from the module
        } else {
            // display one dummy product so the module template is added to the page
            $query->set( 'posts_per_page', 1 );
            $query->set( 'no_found_rows', true );
        }
        $query->set( 'post_type', 'product' );
        wp_enqueue_script( 'tbp-wishlisted', TBP_JS_MODULES . 'wishlisted.js', [], '1.0', [ 'strategy' => 'defer', 'in_footer' => true ] );

        return true;
    }

    public static function module_container_props(array &$attr,array $module_settings,string $mod_name, string $element_id, array $dynamic_query_settings ) {
        $attr['data-tbp_wishlist'] = 1;
        $attr['data-el'] = $element_id;
        $attr['data-id'] = $module_settings['builder_id'];
        if ( ! self::is_active() ) {
            $attr['class'] .= ' tf_opacity';
        }
    }
}