<?php
/**
 * Builder Plugin Compatibility Code
 *
 * @package    Themify_Builder Pro
 */
/**
 * @link https://wordpress.org/plugins/polylang/
 */
class Themify_Builder_Plugin_Compat_polylang {

    /**
     * Enable translation on the Template post type
     */
    static function init() {
        add_filter( 'pll_get_post_types', array( __CLASS__, 'pll_get_post_types' ), 10, 2 );
        add_action( 'current_screen', [ __CLASS__, 'current_screen' ] );
        add_filter( 'wp_insert_post_parent', array( __CLASS__, 'wp_insert_post_parent' ), 100, 3 ); /* override PLL_Admin_Sync::wp_insert_post_parent */
    }

    public static function pll_get_post_types( $post_types, $programmatically_active ) {
        if ( $programmatically_active ) {
            $post_types['tbp_template'] = 'tbp_template';
        }

        return $post_types;
    }

    /* make sure translated templates are put in the correct tbp_theme (the post_parent field) */
    public static function wp_insert_post_parent( $post_parent, $post_id, $postarr ) {
        if ( isset( $_GET['from_post'], $_GET['new_lang'], $_GET['post_type'] ) ) {
            if ( $_GET['post_type'] === 'tbp_template' && ( $id = wp_get_post_parent_id( (int) $_GET['from_post'] ) ) ) {
                $post_parent = $id;
            }
        }

        return $post_parent;
    }

    public static function current_screen() {
        $screen = get_current_screen();
        if ( $screen->base === 'edit' && $screen->post_type === 'tbp_template' ) {
            $default_lang = Tbp_Utils::get_default_language_code();
            if ( ! isset( $_GET['lang'] ) || $_GET['lang'] !== $default_lang ) {
                wp_redirect( add_query_arg( 'lang', $default_lang ) );
                exit;
            }

            add_action( 'admin_notices', [ __CLASS__, 'admin_notices' ] );
        }
    }

    public static function admin_notices() {
        echo '<div class="notice notice-warning"><p>', __( 'This page only shows templates in your default language. Translated templates follow the assignment and conditions you set on the original template.', 'tbp' ), '</p></div>';
    }
}