<?php

defined( 'ABSPATH' ) || exit;

/**
 * Module Name: Wishlist Link
 * Description: 
 */
class TB_Wishlist_Link_Module extends Themify_Builder_Component_Module {
    
    public static function is_available():bool{
        return themify_is_woocommerce_active();
    }

    public static function get_module_name():string {
        return __('Wishlist Link', 'tbp');
    }

    public static function get_module_icon():string {
        return 'heart';
    }

    public static function get_js_css() : array {
        $arr = array(
            'ver' => TBP_VER,
            'css' => TBP_WC_CSS_MODULES . 'wishlist-link'
        );
        if ( ! Themify_Builder_Model::is_front_builder_activate() ) {
            /* this module shares its script with Wishlist Icon module */
            $arr['js'] = TBP_JS_MODULES . 'wishlist-icon';
            Tbp_Wishlist::add_script_vars();
        }

        return $arr;
    }

    public function __construct() {//backward
        if (method_exists('Themify_Builder_Model', 'add_module')) {
            parent::__construct('wc-wishlist-link');
        } else {//backward
            parent::__construct(array(
                'name' => $this->get_name(),
                'slug' => 'wc-wishlist-link',
                'category' => $this->get_group()
            ));
        }
    }

    /**
     * Render plain content for static content.
     */
    public static function get_static_content(array $module):string {
        $output = '';
        if ( ! empty( $module['link'] ) ) {
            $label = $module['label'] !== '' ? $module['label'] : __('Wishlist', 'tbp');
            $output = sprintf( '<a href="%s">%s</a>', esc_attr( $module['link'] ), esc_html( $label ) );
        }

        return $output;
    }

    public function get_name() {//backward
        return self::get_module_name();
    }

    public function get_icon() {//backward
        return self::get_module_icon();
    }

    function get_assets() {
		return self::get_js_css();
    }

    public static function get_styling_image_fields() : array {
        return [
            'b_i' => ''
        ];
    }
}

if ( ! method_exists( 'Themify_Builder_Component_Module', 'get_module_class' ) && TB_Wishlist_Link_Module::is_available() ) {
    if (method_exists('Themify_Builder_Model', 'add_module')) {
        new TB_Wishlist_Link_Module();
    } else {
        Themify_Builder_Model::register_module('TB_Wishlist_Link_Module');
    }
}
