<?php
/**
 * Template Checkout Coupon
 * 
 * Access original fields: $args['mod_settings']
 * @author Themify
 */
if ( ! defined( 'ABSPATH' ) || !themify_is_woocommerce_active() ){
	return;
}

$mod_name = $args['mod_name'];
$element_id = $args['module_ID'];
$fields_args = $args['mod_settings']+ array(
	'lbl_before' => '',
	'lbl_link' => '',
	'css' => '',
	'animation_effect' => ''
);
$container_class = apply_filters('themify_builder_module_classes', array(
	'module',
	'module-' . $mod_name,
	$element_id,
	$fields_args['css']
	), $mod_name, $element_id, $fields_args);

if (!empty($fields_args['global_styles']) && Themify_Builder::$frontedit_active === false) {
	$container_class[] = $fields_args['global_styles'];
}
$container_props = apply_filters('themify_builder_module_container_props', self::parse_animation_effect($fields_args, array(
		'class' => implode(' ', $container_class),
	)), $fields_args, $mod_name, $element_id);
$fields_args['mod_name'] = $mod_name;

if (Themify_Builder::$frontedit_active === false) {
	$container_props['data-lazy'] = 1;
}
?>
<!-- Checkout Coupon -->
<div <?php echo themify_get_element_attributes(self::sticky_element_props($container_props, $fields_args)); ?>>

	<?php
    $container_props = $container_class = $args = null;
    if ( is_checkout() || Themify_Builder::$frontedit_active) {
        if ( ! wc_coupons_enabled() ) {
            if ( current_user_can( 'manage_options' ) ) {
                echo __( 'Coupons are disabled, you can enable them under WooCommerce > Settings.', 'tbp' ), '</div>';
            }
            return;
        }

        add_action( 'wp_footer', [ 'TB_Checkout_Coupon_Module', 'render_form' ] );
        ?>

        <div class="woocommerce-form-coupon-toggle">
            <?php wc_print_notice( '<span>' . esc_html( $fields_args['lbl_before'] ) . '</span>' . ' <a href="#tbp-coupon" class="themify_lightbox">' . esc_html( $fields_args['lbl_link'] ) . '</a>', 'notice' ); ?>
        </div>
    <?php } ?>

</div><!-- /Checkout Coupon -->