<?php
/**
 * Template Featured Image
 * 
 * Access original fields: $args['mod_settings']
 * @author Themify
 */
defined('ABSPATH') || exit; // Exit if accessed directly

$mod_name = $args['mod_name'];
$element_id = $args['module_ID'];
$fields_args = $args['mod_settings']+ array(
	'image_w' => '',
	'image_h' => '',
	'auto_fullwidth' => false,
	'appearance_image' => '',
	'link' => 'permalink',
	'custom_link' => '',
	'open_link' => 'regular',
	'lightbox' => '',
	'lightbox_w' => '',
	'lightbox_h' => '',
	'lightbox_w_unit' => '%',
	'lightbox_h_unit' => '%',
	'fallback_s' => 'no',
	'fallback_i' => '',
	'caption' => '',
	'caption_layout' => 'image_top',
	'caption_on_overlay' => '',
	'css' => '',
	'animation_effect' => ''
);
if (!empty($fields_args['appearance_image'])) {
	$fields_args['appearance_image'] = self::get_checkbox_data($fields_args['appearance_image']);
}
$container_class = apply_filters('themify_builder_module_classes', array(
	'module',
	'module-image',
	'module-' . $mod_name,
	$element_id,
	$fields_args['css'],
	$fields_args['appearance_image']
	), $mod_name, $element_id, $fields_args);
if ($fields_args['caption'] === 'yes') {
	Themify_Builder_Model::load_module_self_style('image', str_replace('image-', '', $fields_args['caption_layout']));
	$container_class[] = 'module-image';
	$container_class[] = $fields_args['caption_layout'];
}
if ('yes' === $fields_args['caption_on_overlay']) {
	$container_class[] = 'active-caption-hover';
}
if ($fields_args['auto_fullwidth'] == '1') {
	$container_class[] = ' auto_fullwidth';
}
if (!empty($fields_args['global_styles']) && Themify_Builder::$frontedit_active === false) {
	$container_class[] = $fields_args['global_styles'];
}
$container_props = apply_filters('themify_builder_module_container_props', self::parse_animation_effect($fields_args, array(
		'class' => implode(' ', $container_class),
	)), $fields_args, $mod_name, $element_id);

if (Themify_Builder::$frontedit_active === false) {
	$container_props['data-lazy'] = 1;
}
?>
<!-- Featured Image module -->
<div <?php echo themify_get_element_attributes(self::sticky_element_props($container_props, $fields_args)); ?>>
    <div class="image-wrap tf_rel">
		<?php
		$container_props = $container_class = $args = null;
		$hasFallback = 'yes' === $fields_args['fallback_s'] && '' !== $fields_args['fallback_i'];
		$hasImage = has_post_thumbnail();
		if ($hasImage === true || $hasFallback === true || Themify_Builder::$frontedit_active === true) {
                themify_before_post_image();
				$hasLink = $fields_args['link'] !== 'none';
				$post_title = esc_attr(get_the_title());
				$img = '';
				$att_id = get_post_thumbnail_id();
				$param_image = array(
					'w' => $fields_args['image_w'],
					'h' => $fields_args['image_h'],
					'src' => $att_id,
					'image_size' => !empty($fields_args['i_s']) ? $fields_args['i_s'] : themify_builder_get('setting-global_feature_size', 'image_global_size_field'),
					'alt' => $post_title
				);
				if (Themify_Builder::$frontedit_active === true) {
					$param_image['attr'] = array('data-w' => 'image_w', 'data-h' => 'image_h');
				}
				if ($hasLink === true) {
					$link_attr = Tbp_Utils::getLinkParams($fields_args, ($hasImage === false && $hasFallback === true && 'media' === $fields_args['link'] ? esc_url($fields_args['fallback_i']) : ''));
					$hasLink = isset($link_attr['href']);
				}
				?>
				<?php if ($hasLink === true): ?>
					<a <?php echo themify_get_element_attributes($link_attr); ?>> 
					<?php endif; ?>

					<?php
					if ($hasImage === true) {
						if ('yes' === $fields_args['caption']) {
							$image_caption = wp_get_attachment_caption($att_id);
						}
						$img = themify_get_image($param_image);
					} elseif ($hasFallback === true) {
						if ('yes' === $fields_args['caption']) {
							$image_caption = wp_get_attachment_caption(attachment_url_to_postid($fields_args['fallback_i']));
						}
						$param_image['src'] = $fields_args['fallback_i'];
						$img = themify_get_image($param_image);
					}
					?>
					<?php if ($img !== ''): ?>
						<?php echo $img ?>
					<?php elseif (Themify_Builder::$frontedit_active === true): ?>
						<img alt="<?php echo $post_title ?>" width="1100" height="1100" src="<?php echo THEMIFY_BUILDER_URI ?>/img/image-placeholder.png">
					<?php endif; ?>

					<?php if ($hasLink === true): ?>
					</a>
				<?php endif; ?>
				<?php
                themify_after_post_image();
		}
		?>
		<?php if (empty($image_caption) || (!empty($image_caption) && 'image-overlay' !== $fields_args['caption_layout'])): ?>
		</div>
		<!-- /image-wrap -->
	<?php endif; ?>
	<?php if (!empty($image_caption)): ?>
		<div class="image-content<?php echo $fields_args['caption_layout'] === 'image-full-overlay' ? ' tf_overflow' : ''; ?>">
			<div class="image-caption tb_text_wrap"<?php if (Themify_Builder::$frontedit_active === true): ?> contenteditable="false" data-name="caption_image"<?php endif; ?>>
				<?php echo apply_filters('themify_builder_module_content', $image_caption); ?>
			</div>
			<!-- /image-caption -->
		</div>
		<!-- /image-content -->
	<?php endif; ?>
	<?php if (!empty($image_caption) && 'image-overlay' === $fields_args['caption_layout']): ?>
	</div>
	<!-- /image-wrap -->
<?php endif; ?>
</div>
<!-- /Featured Image module -->
